<?php

namespace App\Enums;

enum TraderType: string
{
    case REGULAR = 'regular';
    case PREMIUM = 'premium';
    case EXPERT = 'expert';
    case VIP = 'vip';

    public function label(): string
    {
        return match($this) {
            self::REGULAR => 'Regular',
            self::PREMIUM => 'Premium',
            self::EXPERT => 'Expert',
            self::VIP => 'VIP'
        };
    }

    public function color(): string
    {
        return match($this) {
            self::REGULAR => 'blue',
            self::PREMIUM => 'yellow',
            self::EXPERT => 'purple',
            self::VIP => 'green'
        };
    }

    public function maxFollowers(): int
    {
        return match($this) {
            self::REGULAR => 10,
            self::PREMIUM => 50,
            self::EXPERT => 100,
            self::VIP => 500
        };
    }

    public function minimumWinRate(): float
    {
        return match($this) {
            self::REGULAR => 50.0,
            self::PREMIUM => 60.0,
            self::EXPERT => 70.0,
            self::VIP => 80.0
        };
    }
}