<?php

namespace App\Http\Middleware;

use App\Models\Settings;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureKycIsCompleted
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     *
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {

        $user = Auth::user();
        $settings = Settings::select('enable_kyc_registration')->find(1);

        if ($settings && $settings->enable_kyc_registration && $user->account_verify !== 'verified') {
            return redirect()->route('user.kyc.start');
        }

        if (!$user->has_seen_onboarding && $user->email_verified_at !== null) {
            return redirect()->route('user.welcome');
        }

        return $next($request);
    }
}
