<?php

namespace App\Livewire\Admin\ManageDeposits;

use App\Models\Deposit;
use App\Models\User;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Component;

class AddDeposit extends Component
{
    use LivewireAlert;
    public $amount;
    public $addToBalance = 1;
    public $userId;

    #[Computed()]
    public function users(): Collection
    {
        return User::isNotAdmin()->latest()->get();
    }

    public function render()
    {
        return view('livewire.admin.manage-deposits.add-deposit');
    }

    public function placeholder(array $params = [])
    {
        return view('livewire.placeholders.skeleton', $params);
    }

   public function save(): void
{
    $this->authorize('manually create deposit');
    $this->validate([
        'userId' => ['exists:users,id'],
        'amount' => ['required', 'numeric', 'min:0.01'],
    ]);

    $user = User::findOrFail($this->userId);

    
    $deposit = Deposit::create([
        'user_id' => $user->id,
        'amount' => $this->amount,
        'payment_mode' => 'Manual',
        'status' => 'Processed',
    ]);

    
    if ((bool) $this->addToBalance) {
        $user->increment('account_bal', $this->amount);
    }

    
    Cache::forget('total_deposited');
    Cache::forget('chart_pendepsoit');

    
    $this->reset('amount', 'userId', 'addToBalance');
    $this->alert(message: 'Deposit record created successfully.');
    $this->dispatch('close-deposit-modal');
    $this->dispatch('reload-page');
}

}