<?php

namespace App\Livewire\Admin\ManageUsers;

use App\Models\User;
use Illuminate\Validation\Rules\File;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;
use Livewire\WithFileUploads;

class ProfilePicture extends Component
{
    use WithFileUploads;
    use LivewireAlert;

    public User $user;
    public $avatar;

    public function render()
    {
        return view('livewire.admin.manage-users.profile-picture');
    }

    public function updatedAvatar(): void
    {
        try {
            $this->authorize('edit user');
            
            $this->validate([
                'avatar' => [
                    'required',
                    'image',
                    'mimes:jpeg,png,jpg,gif',
                    'max:10240', // 10MB in kilobytes
                ],
            ]);
            
            $path = $this->avatar->store('avatars', 'public');
            $this->user->update(['profile_photo_path' => $path]);
            $this->alert(type: 'success', message: 'Avatar uploaded successfully');
        } catch (\Illuminate\Validation\ValidationException $e) {
            foreach ($e->errors() as $field => $errors) {
                foreach ($errors as $error) {
                    $this->addError($field, $error);
                }
            }
        } catch (\Exception $e) {
            $this->alert(type: 'error', message: 'Error uploading avatar: ' . $e->getMessage());
            \Log::error('Avatar upload error: ' . $e->getMessage() . ' | File: ' . $e->getFile() . ' | Line: ' . $e->getLine());
        }
    }
}
