<?php

namespace App\Livewire\Components;

use Livewire\Component;

class LanguageSelector extends Component
{
    public function setLocale($locale)
    {
        session()->put('locale', $locale);
        return redirect(request()->header('Referer'));
    }

    public function render()
    {
        return view('livewire.components.language-selector', [
            'current_locale' => app()->getLocale(),
            'available_locales' => config('app.available_locales')
        ]);
    }
}