<?php

namespace App\Livewire\User\Membership;

use App\Exceptions\MembershipException;
use App\Models\Settings;
use App\Services\MembershipService;
use Livewire\Component;

class MyCourses extends Component
{
    public $data;

    public function mount(MembershipService $membership)
    {
        $settings = Settings::select('modules')->find(1);
        
        // More robust check for membership module status
        $isMembershipEnabled = $settings 
            && is_array($settings->modules) 
            && ($settings->modules['membership'] === 'true' || $settings->modules['membership'] === true);
        
        if (!$isMembershipEnabled) {
            session()->flash('message', 'Membership module is currently disabled.');
            return redirect()->route('user.dashboard');
        }

        try {
            $this->data = $membership->myCourses(auth()->user()->id);
        } catch (MembershipException $e) {
            session()->flash('message', $e->getMessage());
            return redirect()->route('user.dashboard');
        } catch (\Throwable $e) {
            session()->flash('error', 'An unexpected error occurred: ' . $e->getMessage());
            return redirect()->route('user.dashboard');
        }
    }

    public function render()
    {
        $template = Settings::select('theme')->find(1)->theme;
        return view("{$template}.membership.my-courses")
            ->extends("layouts.{$template}")
            ->title('My Courses');
    }
}