<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Settings extends Model
{
    use HasFactory;

    protected $guarded = [];

	protected $fillable = [
    'site_name', 'description', 'site_title', 'site_address', 'admin_base_url', 
    'logo', 'favicon', 'contact_email', 'notifiable_email', 'currency', 's_currency', 
    'payment_mode', 'location', 's_s_k', 's_p_k', 'pp_cs', 'pp_ci', 'pp_app_id', 
    'keywords', 'enable_trade_mode', 'enable_google_translate', 'enable_weekend_trade', 
    'timezone', 'mail_server', 'emailfrom', 'emailfromname', 'smtp_host', 'smtp_port', 
    'smtp_encrypt', 'smtp_user', 'smtp_password', 'google_secret', 'google_id', 
    'google_redirect', 'referral_commission', 'referral_commission1', 'referral_commission2', 
    'referral_commission3', 'referral_commission4', 'referral_commission5', 'signup_bonus', 
    'deposit_bonus', 'live_chat', 'enable_kyc', 'enable_kyc_registration', 
    'enable_withdrawal_otp', 'enable_email_verification', 'enable_social_login', 
    'withdrawal_option', 'deposit_option', 'auto_merchant_option', 'coinpayment_to_wallet', 
    'auto_deposit_merchant', 'enable_annoucement', 'subscription_service', 'return_capital', 
    'should_cancel_plan', 'subscription_type', 'percentage_fee', 'use_copytrade', 'use_terms', 
    'commission_type', 'billing_period', 'commission_fee', 'monthlyfee', 'quarterlyfee', 
    'yearlyfee', 'modules', 'send_welcome_email', 'edit_email_verification_mail', 
    'install_type', 'receive_deposit_email', 'receive_withdrawal_email', 'receive_buyplan_email', 
    'receive_kyc_submission_email', 'receive_expired_plan_email', 
    'receive_trade_account_submission_email', 'receive_signal_subscribe_email', 
    'receive_buy_course_email', 'receive_payment_method_email', 'send_deposit_email', 
    'send_withdrawal_email', 'send_buyplan_email', 'send_expired_plan_email', 
    'send_trade_request_success_email', 'send_signal_subscribe_email', 'send_buy_course_email', 
    'send_kyc_status_email', 'send_roi_email', 'software_version', 'software_has_update', 
    'redirect_url', 'website_theme', 'referral_proffit_from', 'theme', 'ib_link', 'themes', 
    'credit_card_provider', 'deduction_option', 'welcome_message', 'annoucement', 
    'merchant_key', 'paystack_public_key', 'paystack_secret_key', 'paystack_url', 
    'paystack_email', 'use_crypto_feature', 'crypto_charges', 'currency_rate', 'minamt', 
    'use_transfer', 'min_transfer', 'purchase_code', 'old_version', 'transfer_charges', 
    'binance_secret_key', 'binance_api_key', 'flw_secret_hash', 'flw_secret_key', 
    'flw_public_key', 'telegram_bot_api', 'cp_p_key', 'cp_pv_key', 'cp_m_id', 
    'cp_ipn_secret', 'cp_debug_email', 'password_validation_rules', 'spa_mode', 
    'progress_bar_color', 'use_api_price_for_swap', 'swap_fee', 'show_plans_on_home_page', 
    'instagram_social_link', 'coinbase_apikey', 'coinbase_apiversion', 'x_social_link', 
    'facebook_social_link', 'home_theme', 'site_in_maintenance_mode', 
    'maintenance_mode_token', 'admin_dashboard_logo_size', 'user_dashboard_logo_size', 
    'auth_pages_logo_size', 'website_logo_size'
];

    protected $casts = [
        'return_capital' => 'boolean',
        'should_cancel_plan' => 'boolean',
        'modules' => 'array',
        'themes' => 'array',
        'spa_mode' => 'boolean',
        'use_copytrade' => 'boolean',
        'show_progress_bar' => 'boolean',
        'use_api_price_for_swap' => 'boolean',
        'enable_trade_mode' => 'boolean',
        'enable_google_translate' => 'boolean',
        'enable_weekend_trade' => 'boolean',
        'enable_kyc' => 'boolean',
        'enable_kyc_registration' => 'boolean',
        'enable_withdrawal_otp' => 'boolean',
        'enable_email_verification' => 'boolean',
        'enable_social_login' => 'boolean',
        'enable_annoucement' => 'boolean',
        'use_terms' => 'boolean',
        'edit_email_verification_mail' => 'boolean',
        'send_welcome_email' => 'boolean',
        'receive_deposit_email' => 'boolean',
        'receive_withdrawal_email' => 'boolean',
        'receive_buyplan_email' => 'boolean',
        'receive_kyc_submission_email' => 'boolean',
        'receive_expired_plan_email' => 'boolean',
        'receive_trade_account_submission_email' => 'boolean',
        'receive_signal_subscribe_email' => 'boolean',
        'receive_buy_course_email' => 'boolean',
        'receive_payment_method_email' => 'boolean',
        'send_deposit_email' => 'boolean',
        'send_withdrawal_email' => 'boolean',
        'send_buyplan_email' => 'boolean',
        'send_expired_plan_email' => 'boolean',
        'send_trade_request_success_email' => 'boolean',
        'send_signal_subscribe_email' => 'boolean',
        'send_buy_course_email' => 'boolean',
        'send_kyc_status_email' => 'boolean',
        'send_roi_email' => 'boolean',
        'software_has_update' => 'boolean',
        'use_crypto_feature' => 'boolean',
        'use_transfer' => 'boolean',
        'schedule_system_backup' => 'boolean',
        'show_plans_on_home_page' => 'boolean',
        'site_in_maintenance_mode' => 'boolean',
        'coinpayment_to_wallet' => 'boolean',
        'password_validation_rules' => 'array',
    ];
}
