<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Theme Color Configuration
    |--------------------------------------------------------------------------
    |
    | This configuration file allows you to easily change the entire application's
    | color scheme from one central location. These colors will be used throughout
    | the application and can be dynamically updated.
    |
    */

    // Primary brand colors (Binance Theme)
    'primary' => [
        'main' => '#F0B90B',        // Binance signature yellow/gold
        'light' => '#F3C945',       // Lighter yellow variant
        'dark' => '#D4A309',        // Darker gold for hovers
        'hover' => '#B8930A',       // Hover state
    ],

    // Background colors (Binance Dark Theme)
    'background' => [
        'primary' => '#0B0E11',     // Binance main dark background
        'secondary' => '#161A1E',   // Binance card backgrounds
        'tertiary' => '#1E2329',    // Binance input backgrounds
        'quaternary' => '#2B3139',  // Binance hover backgrounds
    ],

    // Text colors (Binance Style)
    'text' => [
        'primary' => '#FAFAFA',     // Binance primary text (bright white)
        'secondary' => '#EAECEF',   // Binance secondary text
        'muted' => '#B7BDC6',       // Binance muted text
        'disabled' => '#848E9C',    // Binance disabled text
    ],

    // Status colors (Binance Trading Colors)
    'status' => [
        'success' => '#02C076',     // Binance green (buy/profit)
        'warning' => '#F0B90B',     // Binance yellow (warning)
        'error' => '#F84638',       // Binance red (sell/loss)
        'info' => '#3E73C4',        // Binance blue (info)
    ],

    // Border colors (Binance Style)
    'border' => [
        'primary' => '#2B3139',     // Binance primary borders
        'secondary' => '#474D57',   // Binance secondary borders
        'muted' => '#5E6673',       // Binance muted borders
    ],

    // Opacity variants for primary color
    'opacity' => [
        5 => '0.05',   // 5% opacity
        10 => '0.1',   // 10% opacity
        20 => '0.2',   // 20% opacity
        30 => '0.3',   // 30% opacity
        80 => '0.8',   // 80% opacity
    ],

    // Pre-defined color schemes for quick switching
    'schemes' => [
        'binance' => [
            'primary' => '#F0B90B',
            'primary_light' => '#F3C945',
            'primary_dark' => '#D4A309',
        ],
        'blue' => [
            'primary' => '#2563EB',
            'primary_light' => '#3B82F6',
            'primary_dark' => '#1D4ED8',
        ],
        'green' => [
            'primary' => '#10B981',
            'primary_light' => '#34D399',
            'primary_dark' => '#059669',
        ],
        'purple' => [
            'primary' => '#8B5CF6',
            'primary_light' => '#A78BFA',
            'primary_dark' => '#7C3AED',
        ],
        'cyan' => [
            'primary' => '#06B6D4',
            'primary_light' => '#22D3EE',
            'primary_dark' => '#0891B2',
        ],
        'orange' => [
            'primary' => '#F97316',
            'primary_light' => '#FB923C',
            'primary_dark' => '#EA580C',
        ],
        'pink' => [
            'primary' => '#EC4899',
            'primary_light' => '#F472B6',
            'primary_dark' => '#DB2777',
        ],
        'red' => [
            'primary' => '#EF4444',
            'primary_light' => '#F87171',
            'primary_dark' => '#DC2626',
        ],
    ],
];