<x-app-layout>
<x-slot name="title">
        All Trades
    </x-slot>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Completed Trades</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Pair</th>
                                    <th>Amount</th>
                                    <th>Type</th>
                                    <th>Entry Price</th>
                                    <th>Close Price</th>
                                    <th>Profit</th>
                                    <th>Result</th>
                                    <th>Completed At</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($trades as $trade)
                                    <tr>
                                        <td>{{ $trade->user->name }}</td>
                                        <td>{{ $trade->pair }}</td>
                                        <td>{{ $trade->amount }}</td>
                                        <td>{{ $trade->type }}</td>
                                        <td>{{ $trade->entry_price }}</td>
                                        <td>{{ $trade->close_price }}</td>
                                        <td>
                                            <span class="text-{{ $trade->profit_amount >= 0 ? 'success' : 'danger' }}">
                                                {{ $trade->profit_amount }}
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge badge-{{ $trade->result === 'win' ? 'success' : 'danger' }}">
                                                {{ $trade->result }}
                                            </span>
                                        </td>
                                        <td>{{ $trade->completed_at->format('d M, Y H:i') }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">No completed trades found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        {{ $trades->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>




