<x-guest-layout>
    <x-slot:title>
        Confirm password
    </x-slot:title>
    
    <div class="w-full max-w-md">
        <form method="POST" action="{{ route('password.confirm') }}" class="space-y-8">
            @csrf
            {{-- Header --}}
            <div class="text-center">
                <h1 class="text-lg font-medium leading-relaxed text-gray-100">
                    {{ __('This is a secure area of the application. Please confirm your password before continuing.') }}
                </h1>
            </div>
            {{-- Password Input --}}
            <div class="relative">
                <x-form.input 
                    type="password"
                    placeholder="Enter your password"
                    name="password"
                    required
                    autocomplete="current-password"
                    class="w-full bg-theme-tertiary border border-theme-quaternary rounded-lg px-4 py-3 text-gray-100 focus:outline-none focus:border-[#F0B90B]" />
            </div>
            {{-- Submit Button --}}
            <button type="submit"
                class="w-full bg-gradient-to-r from-[#F0B90B] to-[#F0B90B]/80 text-black font-medium px-4 py-3 rounded-lg hover:brightness-110 transition-colors flex items-center justify-center gap-2">
                <span class="indicator-label">
                    Confirm
                </span>
                <span class="indicator-progress hidden">
                    <i data-lucide="loader-2" class="w-4 h-4 animate-spin"></i>
                </span>
            </button>
        </form>
    </div>
</x-guest-layout>

<script>
    lucide.createIcons();

    // Form submission handling
    document.querySelector('form').addEventListener('submit', function() {
        const button = this.querySelector('button[type="submit"]');
        const label = button.querySelector('.indicator-label');
        const progress = button.querySelector('.indicator-progress');

        label.classList.add('hidden');
        progress.classList.remove('hidden');
    });
</script>





