<x-guest-layout>
    <x-slot:title>
        {{ __('reset_password') }}
    </x-slot:title>
    
    <div class="w-full max-w-md">
        <form method="POST" action="{{ route('password.update') }}" class="space-y-8">
            @csrf
            <input type="hidden" name="token" value="{{ $request->route('token') }}">

            {{-- Header --}}
            <div class="text-center space-y-4">
                <h1 class="text-2xl font-medium">
                    {{ __('setup_new_password') }}
                </h1>
                <p class="text-gray-400">
                    {{ __('already_reset_password') }}
                    <a href="{{ url('/login') }}" 
                        class="text-theme-primary hover:text-[#1D4ED8] transition-colors ml-1">
                        {{ __('sign_in') }}
                    </a>
                </p>
            </div>

            {{-- Form Fields --}}
            <div class="space-y-6">
                {{-- Email Field --}}
                <div>
                    <x-form.input 
                        type="text"
                        placeholder="{{ __('email_placeholder') }}"
                        name="email"
                        value="{{ old('email', $request->email) }}"
                        required
                        autofocus
                        autocomplete="username"
                        class="w-full bg-theme-tertiary border border-theme-quaternary rounded-lg px-4 py-3 text-gray-100 focus:outline-none focus:border-theme-primary" />
                </div>

                {{-- Password Field --}}
                <div x-data="{ showPassword: false }">
                    <div class="relative">
                        <x-form.input 
                            x-bind:type="showPassword ? 'text' : 'password'"
                            placeholder="{{ __('password_placeholder') }}"
                            name="password"
                            required
                            autocomplete="new-password"
                            class="w-full bg-theme-tertiary border border-theme-quaternary rounded-lg px-4 py-3 text-gray-100 focus:outline-none focus:border-[#F0B90B]" />
                        
                        <button type="button"
                            @click="showPassword = !showPassword"
                            class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-theme-primary transition-colors">
                            <i data-lucide="eye" x-show="!showPassword" class="w-5 h-5"></i>
                            <i data-lucide="eye-off" x-show="showPassword" class="w-5 h-5"></i>
                        </button>
                    </div>

                    {{-- Password Strength Meter --}}
                    <div class="mt-3 grid grid-cols-4 gap-2">
                        <div class="h-1 rounded bg-theme-tertiary"></div>
                        <div class="h-1 rounded bg-theme-tertiary"></div>
                        <div class="h-1 rounded bg-theme-tertiary"></div>
                        <div class="h-1 rounded bg-theme-tertiary"></div>
                    </div>

                    <p class="mt-2 text-sm text-gray-400">
                        {{ __('password_strength_hint') }}
                    </p>
                </div>

                {{-- Confirm Password Field --}}
                <div>
                    <x-form.input 
                        type="password"
                        placeholder="{{ __('confirm_password_placeholder') }}"
                        name="password_confirmation"
                        required
                        autocomplete="new-password"
                        class="w-full bg-theme-tertiary border border-theme-quaternary rounded-lg px-4 py-3 text-gray-100 focus:outline-none focus:border-theme-primary" />
                </div>
            </div>

            {{-- Submit Button --}}
            <button type="submit"
                class="w-full bg-theme-primary text-white font-medium px-4 py-3 rounded-lg hover:bg-[#1D4ED8] transition-colors flex items-center justify-center gap-2">
                <span class="indicator-label">
                    {{ __('reset_password_button') }}
                </span>
                <span class="indicator-progress hidden">
                    {{ __('please_wait') }}
                    <i data-lucide="loader-2" class="w-4 h-4 animate-spin"></i>
                </span>
            </button>
        </form>
    </div>
</x-guest-layout>


<script>
    lucide.createIcons();

    // Password Strength Meter
    document.addEventListener('DOMContentLoaded', () => {
        const passwordInput = document.querySelector('input[name="password"]');
        const strengthBars = document.querySelectorAll('.h-1.rounded');

        passwordInput.addEventListener('input', function() {
            const password = this.value;
            let strength = 0;

            // Length check
            if (password.length >= 8) strength++;
            // Lowercase check
            if (/[a-z]/.test(password)) strength++;
            // Uppercase check
            if (/[A-Z]/.test(password)) strength++;
            // Number check
            if (/\d/.test(password)) strength++;
            // Special character check
            if (/[^A-Za-z0-9]/.test(password)) strength++;

            // Update strength bars
            strengthBars.forEach((bar, index) => {
                if (index < strength) {
                    bar.classList.remove('bg-theme-tertiary');
                    bar.classList.add('bg-[#F0B90B]');
                } else {
                    bar.classList.remove('bg-[#F0B90B]');
                    bar.classList.add('bg-theme-tertiary');
                }
            });
        });
    });

    // Form submission handling
    document.querySelector('form').addEventListener('submit', function() {
        const button = this.querySelector('button[type="submit"]');
        const label = button.querySelector('.indicator-label');
        const progress = button.querySelector('.indicator-progress');
        label.classList.add('hidden');
        progress.classList.remove('hidden');
    });
</script>





