<x-guest-layout>
    <x-slot:title>
        Two factor authentication
    </x-slot:title>
    
    <div class="w-full max-w-md" x-data="{ recovery: false }">
        <form method="POST" action="{{ route('two-factor.login') }}" class="space-y-8">
            @csrf

            {{-- Header --}}
            <div class="text-center space-y-4">
                <h1 class="text-2xl font-medium">
                    Two-Factor Authentication
                </h1>
                
                <p class="text-gray-400" x-show="! recovery">
                    {{ __('Please confirm access to your account by entering the authentication code provided by your authenticator application.') }}
                </p>
                
                <p class="text-gray-400" x-cloak x-show="recovery">
                    {{ __('Please confirm access to your account by entering one of your emergency recovery codes.') }}
                </p>
            </div>

            {{-- Input Fields --}}
            <div>
                {{-- Authentication Code Input --}}
                <div x-show="! recovery">
                    <x-form.input 
                        id="code"
                        type="text"
                        placeholder="Enter authentication code"
                        inputmode="numeric"
                        name="code"
                        autofocus
                        autocomplete="one-time-code"
                        class="w-full bg-theme-tertiary border border-theme-quaternary rounded-lg px-4 py-3 text-gray-100 focus:outline-none focus:border-theme-primary" />
                </div>

                {{-- Recovery Code Input --}}
                <div x-cloak x-show="recovery">
                    <x-form.input 
                        id="recovery_code"
                        type="text"
                        placeholder="Enter recovery code"
                        inputmode="numeric"
                        name="recovery_code"
                        autofocus
                        autocomplete="one-time-code"
                        class="w-full bg-theme-tertiary border border-theme-quaternary rounded-lg px-4 py-3 text-gray-100 focus:outline-none focus:border-theme-primary" />
                </div>
            </div>

            {{-- Action Buttons --}}
            <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                {{-- Submit Button --}}
                <button type="submit"
                    class="w-full sm:w-auto inline-flex items-center justify-center gap-2 bg-gradient-to-r from-[#F0B90B] to-[#F0B90B]/80 text-black font-medium px-6 py-3 rounded-lg hover:brightness-110 transition-colors min-w-[120px]">
                    <span class="indicator-label">
                        Submit
                    </span>
                    <span class="indicator-progress hidden">
                        <i data-lucide="loader-2" class="w-4 h-4 animate-spin"></i>
                    </span>
                </button>

                {{-- Toggle Button --}}
                <button type="button"
                    x-show="! recovery"
                    x-on:click="
                        recovery = true;
                        $nextTick(() => { $refs.recovery_code?.focus() })
                    "
                    class="w-full sm:w-auto inline-flex items-center justify-center gap-2 bg-theme-tertiary text-gray-300 font-medium px-6 py-3 rounded-lg hover:bg-theme-quaternary transition-colors">
                    <i data-lucide="key" class="w-4 h-4"></i>
                    {{ __('Use a recovery code') }}
                </button>

                <button type="button"
                    x-cloak
                    x-show="recovery"
                    x-on:click="
                        recovery = false;
                        $nextTick(() => { $refs.code?.focus() })
                    "
                    class="w-full sm:w-auto inline-flex items-center justify-center gap-2 bg-theme-tertiary text-gray-300 font-medium px-6 py-3 rounded-lg hover:bg-theme-quaternary transition-colors">
                    <i data-lucide="shield" class="w-4 h-4"></i>
                    {{ __('Use an authentication code') }}
                </button>
            </div>
        </form>
    </div>
</x-guest-layout>

<script>
    lucide.createIcons();

    // Form submission handling
    document.querySelector('form').addEventListener('submit', function() {
        const button = this.querySelector('button[type="submit"]');
        const label = button.querySelector('.indicator-label');
        const progress = button.querySelector('.indicator-progress');

        label.classList.add('hidden');
        progress.classList.remove('hidden');
    });
</script>





