<div class="fixed bottom-4 left-4 z-50">
    <!-- Chat Icon Button -->
    <button wire:click="toggleChat" 
            class="bg-blue-500 hover:bg-blue-600 text-white rounded-full p-3 shadow-lg flex items-center justify-center">
        @if($isOpen)
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>
        @else
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
            </svg>
        @endif
    </button>

    <!-- Chat Window -->
    @if($isOpen)
        <div class="absolute bottom-16 left-0 w-80 bg-white rounded-lg shadow-xl overflow-hidden">
            <!-- Header -->
            <div class="bg-blue-500 text-white p-4">
                <div class="flex justify-between items-center">
                    @if(!$showUserList && $selectedUser)
                        <button wire:click="backToUserList" class="text-white hover:text-gray-200">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                            </svg>
                        </button>
                    @endif
                    <h3 class="font-semibold">
                        {{ $showUserList ? 'Chat Messages' : ($users->firstWhere('id', $selectedUser)?->name ?? 'Chat') }}
                    </h3>
                    <button wire:click="toggleChat" class="text-white hover:text-gray-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            </div>

            <!-- Content -->
            <div class="h-96 flex flex-col">
                @if($showUserList)
                    <!-- Users List -->
                    <div class="flex-1 overflow-y-auto">
                        @foreach($users as $user)
                            <div class="p-4 border-b hover:bg-gray-50 cursor-pointer"
                                 wire:click="selectUser({{ $user->id }})">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center">
                                        <div class="w-10 h-10 bg-gray-200 rounded-full flex items-center justify-center">
                                            <span class="text-gray-700 font-semibold">
                                                {{ substr($user->name, 0, 1) }}
                                            </span>
                                        </div>
                                        <div class="ml-3">
                                            <p class="text-sm font-medium">{{ $user->name }}</p>
                                            <p class="text-xs text-gray-500">
                                                {{ $user->is_online ? 'Online' : 'Offline' }}
                                            </p>
                                        </div>
                                    </div>
                                    @if($user->is_online)
                                        <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <!-- Chat Messages -->
                    <div class="flex-1 overflow-y-auto p-4 space-y-3" id="chat-messages">
                        @foreach($messages as $message)
                            <div class="flex {{ $message->from_user === auth()->id() ? 'justify-end' : 'justify-start' }}">
                                <div class="{{ $message->from_user === auth()->id() 
                                    ? 'bg-blue-500 text-white' 
                                    : 'bg-gray-200 text-gray-800' }} 
                                    rounded-lg px-3 py-2 max-w-[80%] break-words">
                                    <p>{{ $message->message }}</p>
                                    <p class="text-xs {{ $message->from_user === auth()->id() 
                                        ? 'text-blue-100' 
                                        : 'text-gray-500' }} mt-1">
                                        {{ $message->created_at->format('g:i A') }}
                                    </p>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Message Input -->
                    <div class="border-t p-3">
                        <form wire:submit.prevent="sendMessage" class="flex space-x-2">
                            <input type="text" 
                                   wire:model.defer="messageText"
                                   class="flex-1 border rounded-full px-4 py-2 text-sm focus:outline-none focus:border-blue-500"
                                   placeholder="Type your message...">
                            <button type="submit"
                                    class="bg-blue-500 text-white rounded-full p-2 hover:bg-blue-600 focus:outline-none">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                                </svg>
                            </button>
                        </form>
                    </div>
                @endif
            </div>
        </div>
    @endif
</div>





