<div class="space-y-6">
    {{-- Browser Sessions Section --}}
    <div class="space-y-2">
        <h4 class="text-lg font-medium">{{ __('t.browser') }}</h4>
        <p class="text-gray-400">{{ __('t.manage_log_out_sessions') }}</p>
    </div>

    @if(count($this->sessions) > 0)
        <div class="relative overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="text-left text-sm text-gray-400 border-b border-gray-800">
                        <th class="pb-3 font-medium">{{ __('t.user_agent') }}</th>
                        <th class="pb-3 font-medium">{{ __('t.ip_address') }}</th>
                        <th class="pb-3 font-medium">{{ __('t.last_active') }}</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-800">
                    @foreach($this->sessions as $session)
                        <tr class="hover:bg-gray-800/50 transition-colors">
                            <td class="py-4">
                                <span class="flex items-center gap-2 text-gray-400">
                                    @if($session->agent->isDesktop())
                                        <i data-lucide="monitor" class="w-4 h-4"></i>
                                    @else
                                        <i data-lucide="smartphone" class="w-4 h-4"></i>
                                    @endif
                                    {{ $session->agent->platform() ? $session->agent->platform() : __('t.unknown') }}
                                    -
                                    {{ $session->agent->browser() ? $session->agent->browser() : __('t.unknown') }}
                                </span>
                            </td>
                            <td class="py-4">{{ $session->ip_address }}</td>
                            <td class="py-4">
                                @if($session->is_current_device)
                                    <span class="text-theme-primary font-medium">{{ __('t.this_device') }}</span>
                                @else
                                    {{ $session->last_active }}
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif

    <div class="flex items-center gap-4">
        <button 
            wire:click="confirmLogout" 
            wire:loading.attr="disabled"
            class="bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors flex items-center gap-2">
            {{ __('t.log_out_other_browser_sessions') }}
        </button>

        <div wire:loading wire:target="loggedOut">
            <span class="text-theme-primary">{{ __('t.done') }}</span>
        </div>
    </div>

    {{-- Logout Confirmation Modal --}}
    <x-dialog-modal wire:model.live="confirmingLogout">
        <x-slot name="title">
            {{ __('t.log_out_other_browser_sessions') }}
        </x-slot>

        <x-slot name="content">
            <div class="space-y-4">
                <p class="text-gray-300">
                    {{ __('t.confirm_logout_sessions') }}
                </p>

                <div x-data="{}" 
                    x-on:confirming-logout-other-browser-sessions.window="setTimeout(() => $refs.password.focus(), 250)">
                    <input type="password"
                        wire:model="password"
                        x-ref="password"
                        wire:keydown.enter="logoutOtherBrowserSessions"
                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]"
                        placeholder="{{ __('t.password') }}">
                    
                    <x-input-error for="password" class="mt-2" />
                </div>
            </div>
        </x-slot>

        <x-slot name="footer">
            <div class="flex justify-end gap-3">
                <button wire:click="$toggle('confirmingLogout')"
                    class="px-4 py-2 rounded-lg border border-gray-700 text-gray-300 hover:text-gray-100 transition-colors">
                    {{ __('t.cancel') }}
                </button>

                <button wire:click="logoutOtherBrowserSessions"
                    class="bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                    {{ __('t.log_out_other_browser_sessions') }}
                </button>
            </div>
        </x-slot>
    </x-dialog-modal>
</div>



