<div>
    @if($metrics)
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-6">
            {{-- Equity --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Equity</h5>
                    <div class="bg-blue-400/10 text-blue-400 p-2 rounded-lg">
                        <i data-lucide="activity" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'equity') ? Number::format(floatval($metrics['equity']), 2) : 'Not Available' }}
                </p>
            </div>

            {{-- Profit --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Profit</h5>
                    <div class="bg-theme-primary text-theme-primary p-2 rounded-lg">
                        <i data-lucide="trending-up" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'profit') ? Number::format(floatval($metrics['profit']), 2) : 'Not Available' }}
                </p>
            </div>

            {{-- Balance --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Balance</h5>
                    <div class="bg-violet-400/10 text-violet-400 p-2 rounded-lg">
                        <i data-lucide="wallet" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'balance') ? Number::format(floatval($metrics['balance']), 2) : 'Not Available' }}
                </p>
            </div>

            {{-- Highest Balance --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Highest Balance</h5>
                    <div class="bg-gray-400/10 text-gray-400 p-2 rounded-lg">
                        <i data-lucide="coins" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'highestBalance') ? Number::format(floatval($metrics['highestBalance']), 2) : 'Not Available' }}
                </p>
            </div>

            {{-- Highest Balance Date --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Highest Balance Date</h5>
                    <div class="bg-violet-400/10 text-violet-400 p-2 rounded-lg">
                        <i data-lucide="calendar" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'highestBalanceDate') ? \Carbon\Carbon::parse($metrics['highestBalanceDate'])->toDayDateTimeString() : 'Not Available' }}
                </p>
            </div>

            {{-- Margin --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Margin</h5>
                    <div class="bg-red-400/10 text-red-400 p-2 rounded-lg">
                        <i data-lucide="percent" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'margin') ? Number::format(floatval($metrics['margin']), 2) : 'Not Available' }}
                </p>
            </div>

            {{-- Free Margin --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Free Margin</h5>
                    <div class="bg-yellow-400/10 text-yellow-400 p-2 rounded-lg">
                        <i data-lucide="percent" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'freeMargin') ? Number::format(floatval($metrics['freeMargin']), 2) : 'Not Available' }}
                </p>
            </div>

            {{-- Trades --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Trades</h5>
                    <div class="bg-violet-400/10 text-violet-400 p-2 rounded-lg">
                        <i data-lucide="bar-chart" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'trades') ? Number::format(floatval($metrics['trades'])) : 'Not Available' }}
                </p>
            </div>

            {{-- Won Trades --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Won Trades</h5>
                    <div class="bg-theme-primary text-theme-primary p-2 rounded-lg">
                        <i data-lucide="trending-up" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'wonTrades') ? Number::format(floatval($metrics['wonTrades'])) : 'Not Available' }}
                </p>
            </div>

            {{-- Lost Trades --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Lost Trades</h5>
                    <div class="bg-red-400/10 text-red-400 p-2 rounded-lg">
                        <i data-lucide="trending-down" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'lostTrades') ? Number::format(floatval($metrics['lostTrades'])) : 'Not Available' }}
                </p>
            </div>

            {{-- Deposits --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Deposits</h5>
                    <div class="bg-theme-primary text-theme-primary p-2 rounded-lg">
                        <i data-lucide="arrow-down" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'deposits') ? Number::format(floatval($metrics['deposits']), 2) : 'Not Available' }}
                </p>
            </div>

            {{-- Withdrawals --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex justify-between items-start">
                    <h5 class="font-medium">Withdrawal</h5>
                    <div class="bg-red-400/10 text-red-400 p-2 rounded-lg">
                        <i data-lucide="arrow-up" class="w-4 h-4"></i>
                    </div>
                </div>
                <p class="mt-4 text-lg">
                    {{ Arr::exists($metrics, 'withdrawals') ? Number::format(floatval($metrics['withdrawals']), 2) : 'Not Available' }}
                </p>
            </div>
        </div>
    @endif
    
    @if(is_null($metrics))
        <div class="bg-theme-secondary rounded-xl p-12 text-center">
            <i data-lucide="alert-circle" class="w-12 h-12 text-gray-400 mx-auto mb-4"></i>
            <h6 class="text-lg font-medium">
                We are unable to retrieve metrics for this account, please check later.
            </h6>
        </div>
    @endif
</div>

<script>
    lucide.createIcons();
</script>



