<div class="space-y-6">
    {{-- Breadcrumbs --}}
    <div class="flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">Dashboard</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <a href="{{ route('user.copier.show') }}" @if($settings->spa_mode) wire:navigate @endif class="text-gray-400 hover:text-gray-100">Copytrade overview</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">Account Information</span>
    </div>

    <x-danger-alert />
    <x-success-alert />

    {{-- Account Details --}}
    <div class="bg-theme-secondary rounded-xl p-6">
        <div class="grid lg:grid-cols-2 gap-6">
            <div class="space-y-4">
                <div>
                    <span class="text-gray-400">Account:</span>
                    <span class="font-medium ml-2">{{ $account->name }}</span>
                </div>
                <div>
                    <span class="text-gray-400">Account ID:</span>
                    <span class="font-medium ml-2">{{ $account->login }}</span>
                </div>
                <div>
                    <span class="text-gray-400">Account Platform:</span>
                    <span class="font-medium ml-2">{{ $account->platform }}</span>
                </div>
            </div>

            <div class="space-y-4">
                <div>
                    <span class="text-gray-400">Currency:</span>
                    <span class="font-medium ml-2">{{ $account->currency }}</span>
                </div>
                <div>
                    <span class="text-gray-400">Leverage:</span>
                    <span class="font-medium ml-2">{{ $account->leverage }}</span>
                </div>
                <div>
                    <span class="text-gray-400">Server:</span>
                    <span class="font-medium ml-2">{{ $account->server }}</span>
                </div>
            </div>
        </div>
    </div>

    {{-- Metrics Section --}}
    <div x-data="{ showmetrics: true }" x-show="showmetrics">
        @include('millage.copy-trade.metrics')
    </div>
</div>

<script>
    lucide.createIcons();
</script>



