<div class="w-full p-2">
     <x-danger-alert />
    <x-success-alert />
    <div class="bg-theme-secondary rounded-2xl p-6">
        {{-- Header --}}
        <div class="flex items-center gap-4 mb-8">
            <div class="bg-theme-primary/10 p-3 rounded-xl">
                <i class="fas fa-paper-plane w-6 h-6 text-theme-primary"></i>
            </div>
            <div>
                <h1 class="text-xl font-medium">{{ __('t.transfer_funds') }}</h1>
                <div class="text-sm text-gray-400 flex items-center gap-2">
                    <a href="{{ route('user.dashboard') }}" class="hover:text-theme-primary">{{ __('t.dash') }}</a>
                    <i class="fas fa-chevron-right w-4 h-4"></i>
                    <span>{{ __('t.fund_transfer') }}</span>
                </div>
            </div>
        </div>

        @if($show_password)
            <form wire:submit="transfer" class="space-y-6">
        @else
            <form wire:submit="$set('show_password', true)" class="space-y-6">
        @endif
            {{-- Recipient Info --}}
            <div>
                <label class="text-sm text-gray-400 block mb-2">{{ __('t.recipient_details') }}</label>
                <div class="relative">
                    <div class="absolute left-4 top-1/2 -translate-y-1/2">
                        <i class="fas fa-envelope w-5 h-5 text-gray-400"></i>
                    </div>
                    <input 
                        type="text"
                        wire:model='email'
                        placeholder="{{ __('t.enter_email_username') }}"
                        class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 focus:outline-none focus:border-theme-primary"
                        required
                    >
                </div>
            </div>

            {{-- Amount --}}
            <div>
                <label class="text-sm text-gray-400 block mb-2">{{ __('t.amount_transfer') }}</label>
                <div class="relative">
                    <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400">{{ $settings->currency }}</div>
                    <input 
                        type="number"
                        wire:model='amount'
                        min="{{ $settings->min_transfer }}"
                        placeholder="0.00"
                        class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 focus:outline-none focus:border-theme-primary"
                        required
                    >
                </div>
                <p class="mt-2 text-sm text-gray-400">{{ __('t.min_transfer') }} {{ $settings->currency }}{{ $settings->min_transfer }}</p>
            </div>

            {{-- Password (Conditional) --}}
            @if($show_password)
                <div>
                    <label class="text-sm text-gray-400 block mb-2">{{ __('t.confirm_password') }}</label>
                    <div class="relative">
                        <div class="absolute left-4 top-1/2 -translate-y-1/2">
                            <i class="fas fa-key w-5 h-5 text-gray-400"></i>
                        </div>
                        <input 
                            type="password"
                            wire:model='password'
                            placeholder="{{ __('t.enter_password') }}"
                            class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 focus:outline-none focus:border-theme-primary"
                            required
                        >
                    </div>
                </div>
            @endif

            {{-- Transfer Info --}}
            <div class="bg-theme-tertiary rounded-xl p-4">
                <div class="flex items-center justify-between">
                    <span class="text-sm text-gray-400">{{ __('t.transfer_fee') }}</span>
                    <span class="text-theme-primary font-medium">{{ Number::percentage($settings->transfer_charges) }}</span>
                </div>
            </div>

            {{-- Action Buttons --}}
            <div class="flex flex-col sm:flex-row gap-3">
                @if($show_password)
                    <button type="submit" 
                        class="flex-1 bg-theme-primary text-black px-6 py-3 rounded-xl hover:bg-theme-primary-dark transition-colors flex items-center justify-center gap-2">
                        <div wire:loading wire:target="transfer">
                            <i class="fas fa-spinner w-5 h-5 animate-spin"></i>
                        </div>
                        <i class="fas fa-check w-5 h-5" wire:loading.remove wire:target="transfer"></i>
                        <span>{{ __('t.confirm_transfer') }}</span>
                    </button>
                    <button type="button" 
                        wire:click='cancel'
                        class="flex-1 bg-theme-tertiary px-6 py-3 rounded-xl hover:bg-theme-quaternary transition-colors flex items-center justify-center gap-2">
                        <i class="fas fa-times w-5 h-5"></i>
                        <span>{{ __('t.cancel') }}</span>
                    </button>
                @else
                    <button type="submit" 
                        class="w-full bg-theme-primary text-black px-6 py-3 rounded-xl hover:bg-theme-primary-dark transition-colors flex items-center justify-center gap-2">
                        <i class="fas fa-arrow-right w-5 h-5"></i>
                        <span>{{ __('t.continue') }}</span>
                    </button>
                @endif
            </div>
        </form>
    </div>
</div>



