<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'title' => __('Confirm Password'),
    'content' => __('For your security, please confirm your password to continue.'),
    'button' => __('Confirm'),
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'title' => __('Confirm Password'),
    'content' => __('For your security, please confirm your password to continue.'),
    'button' => __('Confirm'),
]); ?>
<?php foreach (array_filter(([
    'title' => __('Confirm Password'),
    'content' => __('For your security, please confirm your password to continue.'),
    'button' => __('Confirm'),
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    $confirmableId = md5($attributes->wire('then'));
?>

<span 
    <?php echo e($attributes->wire('then')); ?> 
    x-data 
    x-ref="span"
    x-on:click="$wire.startConfirmingPassword('<?php echo e($confirmableId); ?>')"
    x-on:password-confirmed.window="setTimeout(() => $event.detail.id === '<?php echo e($confirmableId); ?>' && $refs.span.dispatchEvent(new CustomEvent('then', { bubbles: false })), 250)"
>
    <?php echo e($slot); ?>

</span>

<?php if (! $__env->hasRenderedOnce('2a19e676-58a9-4f0f-b2f2-298804e0bc34')): $__env->markAsRenderedOnce('2a19e676-58a9-4f0f-b2f2-298804e0bc34'); ?>
    <?php if (isset($component)) { $__componentOriginal49bd1c1dd878e22e0fb84faabf295a3f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal49bd1c1dd878e22e0fb84faabf295a3f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dialog-modal','data' => ['wire:model.live' => 'confirmingPassword','maxWidth' => 'lg']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('dialog-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:model.live' => 'confirmingPassword','max-width' => 'lg']); ?>
         <?php $__env->slot('title', null, []); ?> 
            <?php echo e($title); ?>

         <?php $__env->endSlot(); ?>

         <?php $__env->slot('content', null, []); ?> 
            <?php echo e($content); ?>


            <div class="mt-4" 
                 x-data="{}"
                 x-on:confirming-password.window="setTimeout(() => $refs.confirmable_password.focus(), 250)">
                <div class="relative">
                    <input 
                        type="password"
                        class="w-full bg-theme-tertiary border-0 rounded-xl px-4 py-3 text-gray-200 placeholder-gray-500 focus:ring-2 focus:ring-theme-primary"
                        placeholder="<?php echo e(__('Password')); ?>"
                        autocomplete="current-password"
                        x-ref="confirmable_password"
                        wire:model="confirmablePassword"
                        wire:keydown.enter="confirmPassword" 
                    />
                    <div wire:loading class="absolute right-3 top-1/2 -translate-y-1/2">
                        <i data-lucide="loader-2" class="w-5 h-5 animate-spin text-gray-400"></i>
                    </div>
                </div>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['confirmable_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="mt-2 text-sm text-red-400"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
         <?php $__env->endSlot(); ?>

         <?php $__env->slot('footer', null, []); ?> 
            <button 
                type="button"
                wire:click="stopConfirmingPassword"
                wire:loading.attr="disabled"
                class="inline-flex items-center px-4 py-2 bg-gray-800/50 text-gray-300 rounded-lg hover:bg-gray-800 transition-colors"
            >
                <?php echo e(__('Cancel')); ?>

            </button>

            <button 
                type="button"
                wire:click="confirmPassword"
                wire:loading.attr="disabled"
                class="inline-flex items-center px-4 py-2 bg-theme-primary text-white rounded-lg hover:bg-[#1D4ED8] transition-colors"
                dusk="confirm-password-button"
            >
                <span wire:loading.remove wire:target="confirmPassword">
                    <?php echo e($button); ?>

                </span>
                <span wire:loading wire:target="confirmPassword">
                    <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                </span>
            </button>
         <?php $__env->endSlot(); ?>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal49bd1c1dd878e22e0fb84faabf295a3f)): ?>
<?php $attributes = $__attributesOriginal49bd1c1dd878e22e0fb84faabf295a3f; ?>
<?php unset($__attributesOriginal49bd1c1dd878e22e0fb84faabf295a3f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal49bd1c1dd878e22e0fb84faabf295a3f)): ?>
<?php $component = $__componentOriginal49bd1c1dd878e22e0fb84faabf295a3f; ?>
<?php unset($__componentOriginal49bd1c1dd878e22e0fb84faabf295a3f); ?>
<?php endif; ?>
<?php endif; ?>





<?php /**PATH C:\xampp\htdocs\6figs\resources\views/components/confirms-password.blade.php ENDPATH**/ ?>